<?php
require_once 'config.php';

// Check available accounts for each package
$db = getDB();
$amounts = [11, 15, 22, 42, 61];

echo "<h2>Available Accounts Report</h2>";
echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
echo "<tr><th>Package</th><th>Amount</th><th>Available Accounts</th><th>Status</th></tr>";

foreach ($amounts as $amount) {
    $stmt = $db->prepare("SELECT COUNT(*) as count FROM vouchers WHERE amount = ? AND status = 'available'");
    $stmt->bind_param('d', $amount);
    $stmt->execute();
    $stmt->bind_result($available_count);
    $stmt->fetch();
    $stmt->close();
    
    $profile = $GLOBALS['package_mapping'][$amount] ?? 'Unknown';
    $status = $available_count > 0 ? 
        "<span style='color: green;'>✅ Available ($available_count)</span>" : 
        "<span style='color: red;'>❌ Out of Stock</span>";
    
    echo "<tr>";
    echo "<td>$profile</td>";
    echo "<td>GHS $amount</td>";
    echo "<td>$available_count</td>";
    echo "<td>$status</td>";
    echo "</tr>";
}

echo "</table>";

echo "<br><a href='load_preloaded_accounts.php'>Load More Accounts</a>";
?>