CREATE DATABASE hotspot_vouchers;
USE hotspot_vouchers;

CREATE TABLE vouchers (
    id INT AUTO_INCREMENT PRIMARY KEY,
    voucher_code VARCHAR(50) UNIQUE NOT NULL,
    amount DECIMAL(10,2) NOT NULL,
    profile_name VARCHAR(50) NOT NULL,
    status ENUM('available', 'used') DEFAULT 'available',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    used_at TIMESTAMP NULL
);

CREATE TABLE transactions (
    id INT AUTO_INCREMENT PRIMARY KEY,
    paystack_reference VARCHAR(100) UNIQUE NOT NULL,
    username VARCHAR(50),
    amount DECIMAL(10,2) NOT NULL,
    voucher_code VARCHAR(50),
    status ENUM('pending', 'completed', 'failed') DEFAULT 'pending',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);