<?php
// export_users.php - Export users from MikroTik UserManager
require_once 'config.php';

if ($_POST['action'] ?? '' === 'export_users') {
    echo "<h3>Exporting Users from MikroTik UserManager...</h3>";
    
    // SSH command to get all users from UserManager
    $ssh_command = "ssh -o StrictHostKeyChecking=no " . MIKROTIK_USER . "@" . MIKROTIK_HOST . " '/tool user-manager user print'";
    
    $output = shell_exec($ssh_command . " 2>&1");
    
    if ($output) {
        echo "<pre style='background: #000; color: #0f0; padding: 15px; border-radius: 5px;'>" . htmlspecialchars($output) . "</pre>";
        
        // Parse the output to extract usernames
        $lines = explode("\n", $output);
        $users = [];
        
        foreach ($lines as $line) {
            if (strpos($line, 'name=') !== false) {
                // Extract username
                preg_match('/name=([^\s]+)/', $line, $matches);
                if (isset($matches[1])) {
                    $username = $matches[1];
                    $users[] = $username;
                }
            }
        }
        
        if (!empty($users)) {
            echo "<h4>Found " . count($users) . " users:</h4>";
            echo "<textarea style='width: 100%; height: 200px;'>";
            foreach ($users as $user) {
                echo htmlspecialchars($user) . "\n";
            }
            echo "</textarea>";
        }
    } else {
        echo "<p style='color: red;'>Failed to connect to MikroTik or no users found.</p>";
    }
    exit;
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Export Users from MikroTik</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 40px; background: #f5f5f5; }
        .container { background: white; padding: 30px; border-radius: 10px; box-shadow: 0 0 10px rgba(0,0,0,0.1); max-width: 800px; }
        button { padding: 12px 30px; background: #007bff; color: white; border: none; border-radius: 5px; cursor: pointer; font-size: 16px; }
        button:hover { background: #0056b3; }
    </style>
</head>
<body>
    <div class="container">
        <h1>Export Users from MikroTik UserManager</h1>
        <p>This will connect to your MikroTik and export all UserManager users.</p>
        
        <form method="POST">
            <button type="submit" name="action" value="export_users">🚀 Export Users from MikroTik</button>
        </form>
        
        <div style="margin-top: 30px; padding: 15px; background: #e7f3ff; border-radius: 5px;">
            <h3>Manual Export Method:</h3>
            <p>You can also manually export users via SSH:</p>
            <pre style="background: #000; color: #0f0; padding: 15px; border-radius: 5px;">
ssh nketia101@41.155.100.18
/tool user-manager user print
            </pre>
        </div>
    </div>
</body>
</html>