<?php
require_once 'config.php';

class MikroTikAPI {
    private $host;
    private $user;
    private $pass;
    
    public function __construct($host = MIKROTIK_HOST, $user = MIKROTIK_USER, $pass = MIKROTIK_PASS) {
        $this->host = $host;
        $this->user = $user;
        $this->pass = $pass;
    }
    
    public function createHotspotUser($username, $password, $profile) {
        // SSH command to create user
        $ssh_command = "ssh -o StrictHostKeyChecking=no {$this->user}@{$this->host} '/ip hotspot user add name={$username} password={$password} profile={$profile}'";
        
        $output = shell_exec($ssh_command . " 2>&1");
        
        if (strpos($output, 'bad command name') === false) {
            error_log("MikroTik user created: {$username} with profile: {$profile}");
            return true;
        } else {
            error_log("Failed to create MikroTik user: {$output}");
            return false;
        }
    }
    
    public function checkUserExists($username) {
        $ssh_command = "ssh -o StrictHostKeyChecking=no {$this->user}@{$this->host} '/ip hotspot user print where name={$username}'";
        
        $output = shell_exec($ssh_command . " 2>&1");
        
        return strpos($output, $username) !== false;
    }
}

// Usage example:
// $mikrotik = new MikroTikAPI();
// $mikrotik->createHotspotUser('testuser', 'testpass', 'profile name-11GH');
?>