<?php
require_once 'config.php';

// Get the selected amount
$amount = $_GET['amount'] ?? 0;

if (!$amount) {
    header("Location: " . MIKROTIK_LOGIN_URL . "?error=" . urlencode("No amount selected"));
    exit;
}

// Check if there are available accounts for this amount
$db = getDB();
$stmt = $db->prepare("SELECT COUNT(*) as available_count FROM vouchers WHERE amount = ? AND status = 'available'");
$stmt->bind_param('d', $amount);
$stmt->execute();
$stmt->bind_result($available_count);
$stmt->fetch();
$stmt->close();

if ($available_count == 0) {
    header("Location: " . MIKROTIK_LOGIN_URL . "?error=" . urlencode("No accounts available for this package. Please try another package."));
    exit;
}

// Generate reference
$reference = 'KRV' . time() . mt_rand(1000, 9999);

// Save transaction as pending
$db = getDB();
$stmt = $db->prepare("INSERT INTO transactions (paystack_reference, amount, status) VALUES (?, ?, 'pending')");
$stmt->bind_param('si', $reference, $amount);
$stmt->execute();
$stmt->close();

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Processing - KennyRose Wireless</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #0a192f, #1a2a6c, #0056b3);
            color: white;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0;
            padding: 20px;
        }
        .container {
            background: rgba(10, 25, 47, 0.9);
            padding: 40px;
            border-radius: 15px;
            max-width: 500px;
            width: 100%;
            text-align: center;
            border: 1px solid rgba(100, 255, 218, 0.1);
        }
        .spinner {
            border: 4px solid rgba(255,255,255,0.3);
            border-radius: 50%;
            border-top: 4px solid #64ffda;
            width: 50px;
            height: 50px;
            animation: spin 1s linear infinite;
            margin: 20px auto;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        .package-info {
            color: #64ffda;
            font-weight: bold;
            margin: 15px 0;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>Processing Payment</h1>
        <div class="package-info">
            Package: GHS <?php echo $amount; ?> - <?php echo $GLOBALS['package_mapping'][$amount] ?? 'Standard Package'; ?>
        </div>
        <p>Redirecting to Paystack...</p>
        <div class="spinner"></div>
        <p><small>Please do not close this window</small></p>
    </div>

    <script src="https://js.paystack.co/v1/inline.js"></script>
    <script>
        // Initialize Paystack payment
        const handler = PaystackPop.setup({
            key: '<?php echo PAYSTACK_PUBLIC_KEY; ?>',
            email: '<?php echo PAYSTACK_EMAIL; ?>',
            amount: <?php echo $amount * 100; ?>,
            currency: 'GHS',
            ref: '<?php echo $reference; ?>',
            channels: ['mobile_money'],
            onClose: function() {
                window.location.href = '<?php echo MIKROTIK_LOGIN_URL; ?>?error=' + encodeURIComponent('Payment cancelled');
            },
            callback: function(response) {
                // Redirect to success page
                window.location.href = 'success.php?reference=' + response.reference + '&amount=<?php echo $amount; ?>';
            }
        });

        // Open payment immediately
        handler.openIframe();
    </script>
</body>
</html>