<?php
require_once 'config.php';

$reference = $_GET['reference'] ?? '';
$amount = $_GET['amount'] ?? 0;

if (!$reference) {
    header("Location: " . MIKROTIK_LOGIN_URL . "?error=" . urlencode("Invalid reference"));
    exit;
}

// Verify payment with Paystack
$payment_verified = verifyPaystackPayment($reference);

if ($payment_verified) {
    // Find an available preloaded account for this amount
    $db = getDB();
    
    // Get profile name for this amount
    $profile = $GLOBALS['package_mapping'][$amount] ?? 'profile name-11GH';
    
    // Find available account with matching amount
    $stmt = $db->prepare("SELECT id, voucher_code, username, password FROM vouchers WHERE amount = ? AND status = 'available' LIMIT 1");
    $stmt->bind_param('d', $amount);
    $stmt->execute();
    $stmt->bind_result($voucher_id, $voucher_code, $username, $password);
    $stmt->fetch();
    $stmt->close();
    
    if ($username && $password) {
        // Mark voucher as used
        $stmt = $db->prepare("UPDATE vouchers SET status = 'used', used_at = NOW() WHERE id = ?");
        $stmt->bind_param('i', $voucher_id);
        $stmt->execute();
        $stmt->close();
        
        // Save transaction
        $stmt = $db->prepare("UPDATE transactions SET username = ?, password = ?, status = 'completed' WHERE paystack_reference = ?");
        $stmt->bind_param('sss', $username, $password, $reference);
        $stmt->execute();
        $stmt->close();
        
    } else {
        // No available accounts found
        header("Location: " . MIKROTIK_LOGIN_URL . "?error=" . urlencode("No accounts available for this package. Please try again later."));
        exit;
    }
    
} else {
    header("Location: " . MIKROTIK_LOGIN_URL . "?error=" . urlencode("Payment verification failed"));
    exit;
}

function verifyPaystackPayment($reference) {
    $secret_key = PAYSTACK_SECRET_KEY;
    $curl = curl_init();
    
    curl_setopt_array($curl, [
        CURLOPT_URL => "https://api.paystack.co/transaction/verify/" . $reference,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_HTTPHEADER => [
            "Authorization: Bearer $secret_key",
            "Content-Type: application/json",
        ],
    ]);
    
    $response = curl_exec($curl);
    $result = json_decode($response, true);
    
    return ($result['status'] === true && $result['data']['status'] === 'success');
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Successful - KennyRose Wireless</title>
    <style>
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #0a192f, #1a2a6c, #0056b3);
            color: white;
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0;
            padding: 20px;
        }
        .container {
            background: rgba(10, 25, 47, 0.9);
            padding: 40px;
            border-radius: 15px;
            max-width: 500px;
            width: 100%;
            text-align: center;
            border: 1px solid rgba(100, 255, 218, 0.1);
        }
        .success-icon {
            color: #64ffda;
            font-size: 4em;
            margin-bottom: 20px;
        }
        .credentials {
            background: rgba(255,255,255,0.1);
            padding: 20px;
            border-radius: 10px;
            margin: 20px 0;
        }
        .btn {
            background: linear-gradient(135deg, #0056b3, #003d82);
            color: white;
            padding: 15px 30px;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            font-weight: bold;
            cursor: pointer;
            text-decoration: none;
            display: inline-block;
            margin-top: 20px;
        }
        .package-info {
            color: #64ffda;
            font-weight: bold;
            margin: 10px 0;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="success-icon">✓</div>
        <h1>Payment Successful!</h1>
        <p>Your internet access has been activated.</p>
        
        <div class="credentials">
            <h3>Your Login Credentials:</h3>
            <div class="package-info">
                Package: GHS <?php echo htmlspecialchars($amount); ?> - <?php echo htmlspecialchars($profile); ?>
            </div>
            <p><strong>Username:</strong> <?php echo htmlspecialchars($username); ?></p>
            <p><strong>Password:</strong> <?php echo htmlspecialchars($password); ?></p>
            <?php if (isset($voucher_code)): ?>
                <p><strong>Voucher Code:</strong> <?php echo htmlspecialchars($voucher_code); ?></p>
            <?php endif; ?>
        </div>
        
        <p><strong>Instructions:</strong></p>
        <ol style="text-align: left; margin: 15px 0;">
            <li>Connect to the KennyRose WiFi network</li>
            <li>Open your browser if not redirected automatically</li>
            <li>Enter the username and password above</li>
            <li>Click "Connect to Internet"</li>
        </ol>
        
        <a href="<?php echo MIKROTIK_LOGIN_URL; ?>" class="btn">Go to Login Page</a>
    </div>
</body>
</html>