<?php
// update_database.php - Fix database structure
echo "<h2>Updating Database Structure</h2>";

$db = new mysqli('localhost', 'root', '', 'hotspot_vouchers');

if ($db->connect_error) {
    die("Connection failed: " . $db->connect_error);
}

// Add password column to transactions table if it doesn't exist
echo "<h3>1. Checking transactions table...</h3>";
$result = $db->query("SHOW COLUMNS FROM transactions LIKE 'password'");
if ($result->num_rows == 0) {
    $sql = "ALTER TABLE transactions ADD COLUMN password VARCHAR(255) AFTER username";
    if ($db->query($sql)) {
        echo "<p style='color: green;'>✅ Added 'password' column to transactions table</p>";
    } else {
        echo "<p style='color: red;'>❌ Failed to add password column: " . $db->error . "</p>";
    }
} else {
    echo "<p style='color: green;'>✅ 'password' column already exists</p>";
}

// Show current table structure
echo "<h3>2. Current transactions table structure:</h3>";
$result = $db->query("DESCRIBE transactions");
echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
echo "<tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
while ($row = $result->fetch_assoc()) {
    echo "<tr>";
    echo "<td>" . $row['Field'] . "</td>";
    echo "<td>" . $row['Type'] . "</td>";
    echo "<td>" . $row['Null'] . "</td>";
    echo "<td>" . $row['Key'] . "</td>";
    echo "<td>" . $row['Default'] . "</td>";
    echo "<td>" . $row['Extra'] . "</td>";
    echo "</tr>";
}
echo "</table>";

$db->close();

echo "<hr><p><a href='index.php'>← Go to Hotspot Page</a></p>";
?>